/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

// Radial Dimension  conv functions

#include <StdAfx.h>
#include "funcheader.h"
#include "CConvenienceExports.h"


HRESULT TestDrawingRadialCF() 
{
	START_METHOD("RadialDimension")
	
	HRESULT status = CONV_SUCCESS ;
	IApplication *pdApplication = NULL;

	// Get the application
	status = GetProDESKTOPApplication(&pdApplication) ;
	CHECK_RETURN_STATUS(status)

	IGraphicDocument *activeGraphicDoc = NULL;
	IDrawingDocument *activeDraw = NULL;

	status = GetActiveDrawingDoc(&activeDraw, &activeGraphicDoc);
	CHECK_RETURN_STATUS(status)

	IDesign *pDesign= NULL;
	
	AfxMessageBox("Select a View in the Drawing");

	status = CommitToProDESKTOP("Selection", TRUE);
	CHECK_RETURN_STATUS(status)

	ISet *pGraphSet = NULL;
	status = activeGraphicDoc->GetSelection(GetBSTR("Graphic"), &pGraphSet);
	CHECK_RETURN_STATUS(status)

	IIt *pObjectIt = NULL;
	status = (GetCLASS(It))->CreateAObjectIt(pGraphSet, &pObjectIt);
	CHECK_RETURN_STATUS(status)

	IDispatch *pGraph1 = NULL;
	status = pObjectIt->start(&pGraph1);
	CHECK_RETURN_STATUS(status)

	IView *pView1 = CAST(IView, pGraph1);

	status = pView1->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	AfxMessageBox ("Select a Circluar Feature from the Active View");

	status = CommitToProDESKTOP("Selection", TRUE);
	CHECK_RETURN_STATUS(status)

	pGraphSet = NULL;
	status = activeGraphicDoc->GetSelection(GetBSTR("Graphic"), &pGraphSet);
	CHECK_RETURN_STATUS(status)

	pObjectIt = NULL;
	status = (GetCLASS(It))->CreateAObjectIt(pGraphSet, &pObjectIt);
	CHECK_RETURN_STATUS(status)

	pGraph1 = NULL;
	status = pObjectIt->start(&pGraph1);
	CHECK_RETURN_STATUS(status)

	
	IRadialDimLine *pRadialDim = NULL;
	status = RadialDimension(pDesign, activeDraw, CAST(IGraphic, pGraph1), &pRadialDim);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Note");
	CHECK_RETURN_STATUS(status)

	END_METHOD("RadialDimension")
}
